"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CronJob = exports.CRON_EVERY_HOUR = exports.CRON_EVERY_30_MINUTES = exports.CRON_EVERY_MINUTE = exports.CRON_EVERY_30_SECONDS = exports.CRON_EVERY_SECOND = void 0;
const Job_1 = require("../../common/Job");
exports.CRON_EVERY_SECOND = '* * * * * *';
exports.CRON_EVERY_30_SECONDS = '*/30 * * * * *';
exports.CRON_EVERY_MINUTE = '* * * * *';
exports.CRON_EVERY_30_MINUTES = '*/30 * * * *';
exports.CRON_EVERY_HOUR = '0 * * * *';
class CronJob extends Job_1.Job {
    constructor(schedule, task, options = {}) {
        var _a;
        super(options.id);
        this.preventOverrun = (_a = options.preventOverrun) !== null && _a !== void 0 ? _a : true;
        this.schedule = schedule;
        this.task = task;
    }
    getStatus() {
        var _a;
        return ((_a = this.cronInstance) === null || _a === void 0 ? void 0 : _a.running()) ? Job_1.JobStatus.RUNNING : Job_1.JobStatus.STOPPED;
    }
    start() {
        // lazy-require croner to avoid mandatory dependency
        const croner = require('croner');
        if (!croner) {
            throw new Error('Please install "croner" (run "npm i croner") in case you want to use Cron jobs.');
        }
        this.cronInstance = croner.Cron(this.schedule.cronExpression, {
            timezone: this.schedule.timezone,
        }, () => {
            if (!this.task.isExecuting || !this.preventOverrun) {
                this.task.execute();
            }
        });
    }
    stop() {
        var _a;
        (_a = this.cronInstance) === null || _a === void 0 ? void 0 : _a.stop();
    }
}
exports.CronJob = CronJob;
//# sourceMappingURL=CronJob.js.map