"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Task = void 0;
const Logger_1 = require("./Logger");
const Utils_1 = require("./Utils");
class Task {
    constructor(id, handler, errorHandler) {
        this.id = id;
        this.handler = handler;
        this.errorHandler = errorHandler || (0, Logger_1.defaultErrorHandler)(this.id);
        this.isExecuting = false;
    }
    execute() {
        this.isExecuting = true;
        try {
            this.handler();
        }
        catch (err) {
            const errorHandleResult = this.errorHandler(err);
            if ((0, Utils_1.isPromise)(errorHandleResult)) {
                // If we fail while handling an error, oh well
                errorHandleResult.catch((0, Logger_1.loggingErrorHandler)(err));
            }
        }
        this.isExecuting = false;
    }
}
exports.Task = Task;
//# sourceMappingURL=Task.js.map